<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Types extends Model 
{

    protected $table = 'operation_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'name', 'facturable');
    protected $visible = array('client_id', 'name', 'facturable');

    public function jobs()
    {
        return $this->hasMany('Operations');
    }

    public function client()
    {
        return $this->belongsTo('Client');
    }

}